
import pandas as pd

req = pd.read_excel("Agent_Tool.xlsx", sheet_name="Job_Requirements")
cand = pd.read_excel("Agent_Tool.xlsx", sheet_name="Candidate_Data")

scores = []
for _, row in cand.iterrows():
    score = 0
    for i, skill in enumerate(req["Skill"]):
        score += row[skill] * req["Weight"][i]
    scores.append(score)

cand["Total_Score"] = scores
cand.to_csv("resume_scores.csv", index=False)
print("Resume screening completed.")
