
import pandas as pd

employees = pd.read_excel("Agent_Tool.xlsx", sheet_name="Employee_Input")
tasks = pd.read_excel("Agent_Tool.xlsx", sheet_name="Task_Matrix")

output = []

for _, emp in employees.iterrows():
    role_tasks = tasks[tasks["Role"] == emp["Role"]]
    for _, task in role_tasks.iterrows():
        output.append({
            "Employee": emp["Employee Name"],
            "Task": task["Task"],
            "Owner": task["Owner"],
            "Due Days": task["Due (Days)"]
        })

df = pd.DataFrame(output)
df.to_csv("onboarding_tasks_output.csv", index=False)
print("Onboarding tasks generated successfully.")
