import pandas as pd
bank = pd.read_excel('Agent_Tool.xlsx', sheet_name='Bank_Statement')
ledger = pd.read_excel('Agent_Tool.xlsx', sheet_name='Ledger')
merged = pd.merge(bank, ledger, on=['Date','Description'], how='outer', suffixes=('_bank','_ledger'))
merged['Match'] = merged.apply(lambda r: 'Yes' if r['Debit_bank']==r['Debit_ledger'] and r['Credit_bank']==r['Credit_ledger'] else 'No', axis=1)
merged.to_csv('bank_reconciliation_report.csv', index=False)
print('Bank reconciliation completed.')
